"""
HB_Convert V1.3

Last Modified: Oct/26/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_Convert
Description-US: Converts the SmoothEdge Setup  and SlideMode into a Polygonal Mesh

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=28m16s


ChangeLog:

Jun/11/2015 V1.0
- Release Version

Jan/1/2016 V1.1
- Python Rewrite
- Support for Retopo Workflow

Oct/11/2018 V1.2
- New Highres Icon
- Support for Converting Slidemode
- Changed name to HB_Convert

Oct/26/2018 V1.3
- Fixed an issue where Object changes position

"""

import c4d
from c4d import gui, utils


def RemoveChildren(objlist):

    for obj in objlist:
        doc.AddUndo(c4d.UNDOTYPE_DELETE, obj)
        obj.Remove()


    c4d.EventAdd()
    return

def InsertChildren(objlist,root):
    for obj in objlist:

        if obj.GetName() != "HB_Modify_Spline" and obj.GetName() != "HB_Orginal_Spline" and obj.GetName() != "HB_Smoothedge_Deformer" and obj.GetName() != "HB_SlideDeformer":
            doc.AddUndo(c4d.UNDOTYPE_CHANGE, obj)
            obj.InsertUnder(root)
            print "yes"

    c4d.EventAdd()
    return




def deletetags(obj): # Scan Tags on Object

    n       = 1

    tags    = obj.GetTags()

    for tag in tags:
        if not tag: continue
        tagtype = tag.GetType()
        #count   = checktype(tags).count(tagtype)


        if tag.GetName()=="smoothedge-restriction" or  tag.GetName()=="TEMPDISPLAY" :
            doc.AddUndo(c4d.UNDOTYPE_DELETE, tag)
            tag.Remove()
            c4d.EventAdd()



def main():
    doc.StartUndo()






    selobj=doc.GetActiveObject()

    if selobj.GetName() == "HB_Modify_Spline":

        selobj = selobj.GetUp()


    children = selobj.GetChildren()

    if selobj.GetDown().GetName() == "HB_SlideDeformer":
        SlideMode=True
    else:
        SlideMode=False


    selobjpos=selobj.GetMg()


    CSsettings = c4d.BaseContainer()
    NewObj=utils.SendModelingCommand(command = c4d.MCOMMAND_CURRENTSTATETOOBJECT,
                            list = [selobj],
                            mode = c4d.MODELINGCOMMANDMODE_EDGESELECTION,
                            bc = CSsettings,
                            doc = doc,
                            )



    if NewObj[0].GetType()==c4d.Onull:
        NewObjChild=NewObj[0].GetDown()
        NewObjChild.InsertAfter(selobj)
        doc.AddUndo(c4d.UNDOTYPE_NEW, NewObjChild)
    else:
        NewObjChild=NewObj[0]
        NewObjChild.InsertAfter(selobj)
        doc.AddUndo(c4d.UNDOTYPE_NEW, NewObjChild)
        RemoveChildren(NewObjChild.GetChildren())






    doc.AddUndo(c4d.UNDOTYPE_DELETE, selobj)
    selobj.Remove()





    InsertChildren(children,NewObjChild)
    deletetags(NewObjChild)
    doc.AddUndo(c4d.UNDOTYPE_BITS, NewObjChild)
    NewObjChild.SetBit(c4d.BIT_ACTIVE)
    NewObjChild.SetMg(selobjpos)

    if SlideMode == True:

        deletetags(NewObjChild)

        SlideProxy=doc.SearchObject("HB_SlideProxy")
        doc.AddUndo(c4d.UNDOTYPE_DELETE, SlideProxy)
        SlideProxy.Remove()


    c4d.EventAdd()
    doc.EndUndo()



if __name__=='__main__':
    main()